#include <stdint.h>

#define MAX_TIMINGS 256

typedef struct 
{
	uint64_t CumulativeTime;
	uint32_t MinTime;
	uint32_t MaxTime;
	uint32_t Timings[MAX_TIMINGS];
	uint32_t NumTimings;
	uint32_t LastWriteIndex;
} TIMING;

void Timing_Reset(TIMING *);
void Timing_Update(TIMING *, uint32_t Time);

uint32_t Timing_GetMinTime();
uint32_t Timing_GetMaxTime();
uint32_t Timing_GetAverageTime();
